USE [GENISIS_DB]
GO
/****** Object:  Table [dbo].[Role_Type]    Script Date: 4/18/2017 4:06:30 PM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
CREATE TABLE [dbo].[Role_Type](
	[Role_Type_id] [int] NOT NULL,
	[Role_Name] [varchar](50) NOT NULL,
	[Role_Description] [varchar](50) NOT NULL,
 CONSTRAINT [Role_Type_pk] PRIMARY KEY CLUSTERED 
(
	[Role_Type_id] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]

GO
SET ANSI_PADDING OFF
GO
/****** Object:  Table [dbo].[User]    Script Date: 4/18/2017 4:06:30 PM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
CREATE TABLE [dbo].[User](
	[User_id] [varchar](50) NOT NULL,
	[First_Name] [varchar](50) NOT NULL,
	[Middle_Name] [varchar](50) NULL,
	[Last_Name] [varchar](50) NOT NULL,
	[Last_Name2] [varchar](50) NULL,
	[Create_Date] [datetime] NOT NULL,
	[Email_id] [varchar](320) NOT NULL,
	[User_Active] [tinyint] NOT NULL,
	[Active_date] [datetime] NOT NULL,
	[Inactive_date] [datetime] NULL,
 CONSTRAINT [User_pk] PRIMARY KEY CLUSTERED 
(
	[User_id] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]

GO
SET ANSI_PADDING OFF
GO
/****** Object:  Table [dbo].[User_Approver]    Script Date: 4/18/2017 4:06:30 PM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
CREATE TABLE [dbo].[User_Approver](
	[Id] [int] NOT NULL,
	[User_id] [varchar](50) NOT NULL,
	[User_Approver_id] [varchar](50) NOT NULL,
 CONSTRAINT [User_Approver_pk] PRIMARY KEY CLUSTERED 
(
	[Id] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]

GO
SET ANSI_PADDING OFF
GO
/****** Object:  Table [dbo].[User_Role_Type]    Script Date: 4/18/2017 4:06:30 PM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
CREATE TABLE [dbo].[User_Role_Type](
	[Id] [int] NOT NULL,
	[Role_Type_id] [int] NOT NULL,
	[User_Type_id] [int] NOT NULL,
	[User_id] [varchar](50) NOT NULL,
	[Start_Date] [datetime] NOT NULL,
	[End_Date] [datetime] NULL,
 CONSTRAINT [User_Role_Type_pk] PRIMARY KEY CLUSTERED 
(
	[Id] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]

GO
SET ANSI_PADDING OFF
GO
/****** Object:  Table [dbo].[User_Type]    Script Date: 4/18/2017 4:06:30 PM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
CREATE TABLE [dbo].[User_Type](
	[User_Type_id] [int] NOT NULL,
	[User_Type_desc] [varchar](50) NOT NULL,
 CONSTRAINT [User_Type_pk] PRIMARY KEY CLUSTERED 
(
	[User_Type_id] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]

GO
SET ANSI_PADDING OFF
GO
ALTER TABLE [dbo].[User_Approver]  WITH CHECK ADD  CONSTRAINT [User_Approver_User] FOREIGN KEY([User_id])
REFERENCES [dbo].[User] ([User_id])
GO
ALTER TABLE [dbo].[User_Approver] CHECK CONSTRAINT [User_Approver_User]
GO
ALTER TABLE [dbo].[User_Approver]  WITH CHECK ADD  CONSTRAINT [User_Approver_User_id] FOREIGN KEY([User_Approver_id])
REFERENCES [dbo].[User] ([User_id])
GO
ALTER TABLE [dbo].[User_Approver] CHECK CONSTRAINT [User_Approver_User_id]
GO
ALTER TABLE [dbo].[User_Role_Type]  WITH CHECK ADD  CONSTRAINT [FK_User_typeID] FOREIGN KEY([User_Type_id])
REFERENCES [dbo].[User_Type] ([User_Type_id])
GO
ALTER TABLE [dbo].[User_Role_Type] CHECK CONSTRAINT [FK_User_typeID]
GO
ALTER TABLE [dbo].[User_Role_Type]  WITH CHECK ADD  CONSTRAINT [User_Role_Type_Role_Type] FOREIGN KEY([Role_Type_id])
REFERENCES [dbo].[Role_Type] ([Role_Type_id])
GO
ALTER TABLE [dbo].[User_Role_Type] CHECK CONSTRAINT [User_Role_Type_Role_Type]
GO
ALTER TABLE [dbo].[User_Role_Type]  WITH CHECK ADD  CONSTRAINT [User_Role_Type_User] FOREIGN KEY([User_id])
REFERENCES [dbo].[User] ([User_id])
GO
ALTER TABLE [dbo].[User_Role_Type] CHECK CONSTRAINT [User_Role_Type_User]
GO

EXEC sp_addrolemember N'db_datareader', N'genisis'
EXEC sp_addrolemember N'db_datawriter', N'genisis'

sp_rename'User','Users'
